package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VenvioOs2Os3Dao;
import com.ejie.ab04b.model.VenvioOs2Os3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VenvioOs2Os3ServiceImpl generated by UDA, 26-jun-2017 10:01:01.
 * 
 * @author UDA
 */

@Service(value = "venvioOs2Os3Service")
public class VenvioOs2Os3ServiceImpl implements VenvioOs2Os3Service {

	@Autowired
	private VenvioOs2Os3Dao venvioOs2Os3Dao;

	/**
	 * Inserts a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioOs2Os3
	 *            VenvioOs2Os3
	 *  VenvioOs2Os3
	 *
	 * @param venvioOs2Os3 the venvio os 2 os 3
	 * @return the venvio os 2 os 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VenvioOs2Os3 add(VenvioOs2Os3 venvioOs2Os3) {
		return this.venvioOs2Os3Dao.add(venvioOs2Os3);
	}

	/**
	 * Updates a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioOs2Os3
	 *            VenvioOs2Os3
	 *  VenvioOs2Os3
	 *
	 * @param venvioOs2Os3 the venvio os 2 os 3
	 * @return the venvio os 2 os 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VenvioOs2Os3 update(VenvioOs2Os3 venvioOs2Os3) {
		return this.venvioOs2Os3Dao.update(venvioOs2Os3);
	}

	/**
	 * Finds a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioOs2Os3
	 *            VenvioOs2Os3
	 *  VenvioOs2Os3
	 *
	 * @param venvioOs2Os3 the venvio os 2 os 3
	 * @return the venvio os 2 os 3
	 */
	public VenvioOs2Os3 find(VenvioOs2Os3 venvioOs2Os3) {
		return (VenvioOs2Os3) this.venvioOs2Os3Dao.find(venvioOs2Os3);
	}

	/**
	 * Deletes a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioOs2Os3
	 *            VenvioOs2Os3
	 *
	 * @param venvioOs2Os3 the venvio os 2 os 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VenvioOs2Os3 venvioOs2Os3) {
		this.venvioOs2Os3Dao.remove(venvioOs2Os3);
	}

	/**
	 * Finds a list of rows in the VenvioOs2Os3 table.
	 * 
	 *  venvioOs2Os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VenvioOs2Os3>
	 *
	 * @param venvioOs2Os3 the venvio os 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VenvioOs2Os3> findAll(VenvioOs2Os3 venvioOs2Os3,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VenvioOs2Os3>) this.venvioOs2Os3Dao.findAll(venvioOs2Os3,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VenvioOs2Os3 table using like.
	 * 
	 *  venvioOs2Os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VenvioOs2Os3>
	 *
	 * @param venvioOs2Os3 the venvio os 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VenvioOs2Os3> findAllLike(VenvioOs2Os3 venvioOs2Os3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VenvioOs2Os3>) this.venvioOs2Os3Dao.findAllLike(
				venvioOs2Os3, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VenvioOs2Os3 table.
	 * 
	 *  filterVenvioOs2Os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVenvioOs2Os3 the filter venvio os 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VenvioOs2Os3 filterVenvioOs2Os3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.venvioOs2Os3Dao.removeMultiple(filterVenvioOs2Os3,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the VenvioOs2Os3 table.
	 * 
	 *  filterVenvioOs2Os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VenvioOs2Os3>
	 *
	 * @param filterVenvioOs2Os3 the filter venvio os 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VenvioOs2Os3> filter(
			VenvioOs2Os3 filterVenvioOs2Os3, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<VenvioOs2Os3> listaVenvioOs2Os3 = this.venvioOs2Os3Dao
				.findAllLike(filterVenvioOs2Os3, jqGridRequestDto, false);
		Long recordNum = this.venvioOs2Os3Dao.findAllLikeCount(
				filterVenvioOs2Os3 != null ? filterVenvioOs2Os3
						: new VenvioOs2Os3(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VenvioOs2Os3>> reorderSelection = this.venvioOs2Os3Dao
					.reorderSelection(filterVenvioOs2Os3, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VenvioOs2Os3>(jqGridRequestDto,
					recordNum, listaVenvioOs2Os3, reorderSelection);
		}
		return new JQGridResponseDto<VenvioOs2Os3>(jqGridRequestDto, recordNum,
				listaVenvioOs2Os3);
	}

	/**
	 * Searches rows in the VenvioOs2Os3 table.
	 * 
	 *  filterVenvioOs2Os3
	 *            VenvioOs2Os3
	 *  searchVenvioOs2Os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VenvioOs2Os3>>
	 *
	 * @param filterVenvioOs2Os3 the filter venvio os 2 os 3
	 * @param searchVenvioOs2Os3 the search venvio os 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VenvioOs2Os3>> search(
			VenvioOs2Os3 filterVenvioOs2Os3, VenvioOs2Os3 searchVenvioOs2Os3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.venvioOs2Os3Dao.search(filterVenvioOs2Os3,
				searchVenvioOs2Os3, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VenvioOs2Os3 table.
	 * 
	 *  filterVenvioOs2Os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVenvioOs2Os3 the filter venvio os 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VenvioOs2Os3 filterVenvioOs2Os3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.venvioOs2Os3Dao.reorderSelection(filterVenvioOs2Os3,
				jqGridRequestDto, startsWith);
	}

}
